/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ast.Block;
import sedonac.ast.Expr;
import sedonac.ast.LocalScope;
import sedonac.ast.MethodDef;
import sedonac.ast.ParamDef;
import sedonac.ast.Stmt;
import sedonac.ast.VarDef;
import sedonac.namespace.ArrayType;
import sedonac.namespace.Field;
import sedonac.namespace.Method;
import sedonac.namespace.Namespace;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ResolveExpr
extends CompilerStep {
    int numLocalsInScope;
    int maxLocals;
    Stack scopeStack;
    int foreachDepth;
    HashMap labels;
    ArrayList gotos;

    public void run() {
        this.log.debug("  ResolveExpr");
        this.walkAst(3);
        this.quitIfErrors();
    }

    public void enterMethod(MethodDef methodDef) {
        super.enterMethod(methodDef);
        this.numLocalsInScope = 0;
        this.maxLocals = 0;
        this.labels = null;
        this.gotos = null;
    }

    public void enterBlock(Block block) {
        this.enterScope(block);
    }

    public void exitBlock(Block block) {
        this.exitScope(block);
    }

    public void exitMethod(MethodDef methodDef) {
        methodDef.maxLocals = this.maxLocals;
        this.resolveGotos();
    }

    public void enterStmt(Stmt stmt) {
        if (stmt instanceof LocalScope) {
            this.enterScope((LocalScope)((Object)stmt));
        }
        if (stmt.id == 6) {
            ++this.foreachDepth;
        }
        this.mapLabel(stmt);
        switch (stmt.id) {
            case 1: {
                this.exprStmt((Stmt.ExprStmt)stmt);
                break;
            }
            case 2: {
                this.localDefStmt((Stmt.LocalDef)stmt);
                break;
            }
            case 3: {
                this.returnStmt((Stmt.Return)stmt);
                break;
            }
            case 5: {
                this.forStmt((Stmt.For)stmt);
                break;
            }
            case 12: {
                this.gotoStmt((Stmt.Goto)stmt);
                break;
            }
        }
    }

    public void exitStmt(Stmt stmt) {
        if (stmt instanceof LocalScope) {
            this.exitScope((LocalScope)((Object)stmt));
        }
        if (stmt.id == 6) {
            --this.foreachDepth;
        }
    }

    private final void exprStmt(Stmt.ExprStmt exprStmt) {
        exprStmt.expr.leave = false;
    }

    private final void localDefStmt(Stmt.LocalDef localDef) {
        localDef.declared = true;
    }

    private final void returnStmt(Stmt.Return return_) {
        return_.foreachDepth = this.foreachDepth;
    }

    private final void forStmt(Stmt.For for_) {
        if (for_.update != null) {
            for_.update.leave = false;
        }
    }

    private final void mapLabel(Stmt stmt) {
        String string = stmt.label;
        if (string == null) {
            return;
        }
        if (this.labels == null) {
            this.labels = new HashMap(13);
        }
        if (this.labels.get(string) != null) {
            this.err("Duplicate label '" + string + '\'', stmt.loc);
        } else {
            this.labels.put(string, stmt);
        }
    }

    private final void gotoStmt(Stmt.Goto goto_) {
        if (this.gotos == null) {
            this.gotos = new ArrayList(8);
        }
        this.gotos.add(goto_);
    }

    private final void resolveGotos() {
        if (this.gotos == null) {
            return;
        }
        if (this.labels == null) {
            this.labels = new HashMap();
        }
        int n = 0;
        while (n < this.gotos.size()) {
            Stmt.Goto goto_ = (Stmt.Goto)this.gotos.get(n);
            goto_.destStmt = (Stmt)this.labels.get(goto_.destLabel);
            if (goto_.destStmt == null) {
                this.err("Unknown label '" + goto_.destLabel + '\'', goto_.loc);
            }
            ++n;
        }
    }

    public Expr expr(Expr expr) {
        switch (expr.id) {
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                expr.type = ((Expr.Unary)expr).operand.type;
                break;
            }
            case 21: 
            case 27: 
            case 28: {
                expr.type = this.ns.boolType;
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                expr.type = this.ns.boolType;
                break;
            }
            case 43: {
                return this.resolveAdd((Expr.Binary)expr);
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 75: {
                expr.type = ((Expr.Binary)expr).lhs.type;
                break;
            }
            case 57: {
                expr.type = ((Expr.Ternary)expr).trueExpr.type;
                break;
            }
            case 58: {
                expr = this.resolveName((Expr.Name)expr);
                break;
            }
            case 61: {
                expr.type = this.curType;
                break;
            }
            case 62: {
                expr.type = this.curType.base;
                break;
            }
            case 64: {
                expr = this.resolveIndex((Expr.Index)expr);
                break;
            }
            case 65: {
                expr = this.resolveCall((Expr.Call)expr);
                break;
            }
            case 67: {
                expr.type = this.ns.voidType;
                break;
            }
            case 73: {
                this.resolveNew((Expr.New)expr);
                break;
            }
            case 74: {
                expr.type = this.ns.voidType;
                break;
            }
        }
        if (expr.type == null) {
            throw this.err("Expr not typed: " + expr, expr.loc);
        }
        return expr;
    }

    public Expr resolveAdd(Expr.Binary binary) {
        Expr expr = binary.lhs;
        Expr expr2 = binary.rhs;
        binary.type = expr.type;
        if (expr.id == 9 || expr.id == 72) {
            Expr.Interpolation interpolation = new Expr.Interpolation(expr.loc);
            interpolation.type = this.ns.strType;
            if (expr.id == 9) {
                interpolation.parts.add(expr);
            } else {
                interpolation.parts.addAll(((Expr.Interpolation)expr).parts);
            }
            if (expr2.id == 72) {
                interpolation.parts.addAll(((Expr.Interpolation)expr2).parts);
            } else {
                interpolation.parts.add(expr2);
            }
            return interpolation;
        }
        return binary;
    }

    public Expr resolveIndex(Expr.Index index) {
        Type type = index.target.type;
        if (!type.isArray()) {
            if (type != Namespace.error) {
                this.err("Cannot use [] operator on '" + type + '\'', index.loc);
            }
            index.type = Namespace.error;
            return index;
        }
        index.type = type.arrayOf();
        return index;
    }

    public void resolveNew(Expr.New new_) {
        new_.type = new_.arrayLength == null ? new_.of : new ArrayType(new_.loc, new_.of, new ArrayType.UnresolvedLen(new_.arrayLength.toString()));
    }

    private final void enterScope(LocalScope localScope) {
        Stmt.LocalDef[] localDefArray = localScope.getLocals();
        HashMap<String, Stmt.LocalDef> hashMap = new HashMap<String, Stmt.LocalDef>(localDefArray.length * 3);
        int n = 0;
        int n2 = 0;
        while (n2 < localDefArray.length) {
            Stmt.LocalDef localDef = localDefArray[n2];
            String string = localDef.name;
            if (this.resolveVar(string) != null || hashMap.get(string) != null) {
                this.err("Variable '" + string + "' already defined in scope", localDef.loc);
            }
            ++n;
            ++this.numLocalsInScope;
            localDef.index = localDef.index;
            if (localDef.type.isWide()) {
                ++this.numLocalsInScope;
                ++n;
            }
            localDef.declared = false;
            int n3 = localDef.index + 1;
            if (localDef.type.isWide()) {
                ++n3;
            }
            if (n3 > this.maxLocals) {
                this.maxLocals = n3;
            }
            hashMap.put(string, localDef);
            ++n2;
        }
        this.scopeStack.push(new ScopeStackItem(localScope, n));
    }

    private final void exitScope(LocalScope localScope) {
        ScopeStackItem scopeStackItem = (ScopeStackItem)this.scopeStack.pop();
        if (scopeStackItem.scope != localScope) {
            throw new IllegalStateException();
        }
        this.numLocalsInScope -= scopeStackItem.numLocals;
    }

    public Expr resolveName(Expr.Name name) {
        Location location = name.loc;
        String string = name.name;
        Expr expr = name.target;
        if (expr != null) {
            Type type = expr.type;
            Slot slot = type.slot(string);
            if (expr.id == 70) {
                if (string.equals("type")) {
                    return new Expr.Literal(expr.loc, this.ns, 11, (Object)expr.type);
                }
                if (string.equals("sizeof")) {
                    return new Expr.Literal(expr.loc, this.ns, 14, (Object)expr.type);
                }
                if (slot != null && slot.isReflective()) {
                    return new Expr.Literal(expr.loc, this.ns, 12, (Object)slot);
                }
            }
            if (slot instanceof Field) {
                Field field = (Field)slot;
                if (expr.id == 12 && slot.qname().equals("sys::Slot.id")) {
                    return new Expr.Literal(location, 15, field.type(), (Object)expr);
                }
                return new Expr.Field(location, expr, field, name.safeNav);
            }
            if (expr.type != Namespace.error) {
                this.err("Unknown field: " + type.signature() + '.' + string, name.loc);
            }
            name.type = Namespace.error;
            return name;
        }
        VarDef varDef = this.resolveVar(string);
        if (varDef != null) {
            if (varDef.isParam()) {
                return new Expr.Param(location, string, (ParamDef)varDef);
            }
            return new Expr.Local(location, (Stmt.LocalDef)varDef);
        }
        Slot slot = this.curType.slot(string);
        if (slot instanceof Field) {
            expr = slot.isStatic() ? null : new Expr.This(location);
            return new Expr.Field(location, expr, (Field)slot, name.safeNav);
        }
        this.err("Unknown var: " + string, name.loc);
        name.type = Namespace.error;
        return name;
    }

    public VarDef resolveVar(String string) {
        if (this.curMethod == null) {
            return null;
        }
        ParamDef[] paramDefArray = this.curMethod.params;
        int n = 0;
        while (n < paramDefArray.length) {
            if (paramDefArray[n].name.equals(string)) {
                return paramDefArray[n];
            }
            ++n;
        }
        n = this.scopeStack.size() - 1;
        while (n >= 0) {
            ScopeStackItem scopeStackItem = (ScopeStackItem)this.scopeStack.get(n);
            Stmt.LocalDef localDef = scopeStackItem.scope.resolveLocal(string);
            if (localDef != null && localDef.declared) {
                return localDef;
            }
            --n;
        }
        return null;
    }

    public Expr resolveCall(Expr.Call call) {
        String string;
        Slot slot;
        Type type = this.curType;
        if (call.target != null) {
            type = call.target.type;
        }
        if ((slot = type.slot(string = call.name)) == null) {
            if (type != Namespace.error) {
                this.err("Unknown method '" + type + '.' + string + '\'', call.loc);
            }
            call.type = Namespace.error;
            return call;
        }
        if (slot.isField()) {
            this.err("Cannot call field '" + type + '.' + string + "' as method", call.loc);
            call.type = Namespace.error;
            return call;
        }
        Method method = (Method)slot;
        call.type = method.returnType();
        call.method = method;
        if (call.args.length == 1 && call.args[0].id == 72) {
            Type type2 = this.ns.resolveType("sys::OutStream");
            if (method.returnType().is(type2)) {
                ((Expr.Interpolation)call.args[0]).callOk = true;
            } else {
                this.err("String interpolation requires that '" + method.qname() + "' return OutStream", call.loc);
            }
        }
        if (call.target == null && !method.isStatic()) {
            call.target = new Expr.This(call.loc);
        }
        return call;
    }

    private final /* synthetic */ void this() {
        this.numLocalsInScope = 0;
        this.maxLocals = 0;
        this.scopeStack = new Stack();
    }

    public ResolveExpr(Compiler compiler) {
        super(compiler);
        this.this();
    }

    static class ScopeStackItem {
        LocalScope scope;
        int numLocals;

        ScopeStackItem(LocalScope localScope, int n) {
            this.scope = localScope;
            this.numLocals = n;
        }
    }
}

